using System.Text;

using Newtonsoft.Json.Linq;

using ProTerminal.Api.Example;

Console.OutputEncoding = Encoding.UTF8;

var routerClient = new RouterClient();
routerClient.WhenBroadcasted += routerClientWhenBroadcasted;
resetConsole();


var baseCommand    = string.Empty;
var minorCommand   = string.Empty;
var listenedEntity = string.Empty;

while (true)
{
    var keyinfo = Console.ReadKey(true);

    if (keyinfo.Key == ConsoleKey.End)
    {
        if (!string.IsNullOrWhiteSpace(listenedEntity))
        {
            Console.WriteLine($"Выполнена отписка прослушки сущности ${listenedEntity}");
            routerClient.UnListen($"#Data.Bus.{listenedEntity}");
        }

        listenedEntity = string.Empty;

        resetConsole();
        baseCommand = minorCommand = string.Empty;
    }

    var command = Console.ReadLine();

    if (!string.IsNullOrEmpty(command))
    {
        if (string.IsNullOrWhiteSpace(baseCommand))
        {
            baseCommand = command;
        }
        else
        {
            minorCommand = command;
        }

        switch (baseCommand)
        {
        case "1":
        {
            Console.WriteLine("         1 - AllTradeEntity ленты сделок");
            Console.WriteLine("         2 - OrderBookEntity стакана");
            Console.WriteLine("         3 - FinInfoParamsEntity параметры торговли"); //!!!
            Console.WriteLine("         4 - FinInfoLastEntity состояние торговли");
            Console.WriteLine("         5 - FinInfoOrderBookEntity состояние торговли");
            Console.WriteLine("         6 - ClientPositionEntity Текущая позиция по выпуску");
            Console.WriteLine("         7 - ClientBalanceEntity Баланс портфеля субсчёта");
            Console.WriteLine("         либо введите название сущности");

            switch (minorCommand)
            {
            case "1":
            {
                _ = listenCommand("AllTradeEntity");

                break;
            }

            case "2":
            {
                _ = listenCommand("OrderBookEntity");

                break;
            }

            case "3":
            {
                _ = listenCommand("FinInfoParamsEntity");

                break;
            }

            case "4":
            {
                _ = listenCommand("FinInfoLastEntity");

                break;
            }

            case "5":
            {
                _ = listenCommand("FinInfoOrderBookEntity");

                break;
            }

            case "6":
            {
                _ = listenCommand("PositionEntity");

                break;
            }


            default:
            {
                if (!string.IsNullOrWhiteSpace(minorCommand))
                {
                    _ = listenCommand(minorCommand);
                }

                break;
            }
            }

            break;
        }

        case "2":
        {
            Console.WriteLine("         1 - Запрос справочника AssetInfoEntity");
            Console.WriteLine("         2 - Запрос справочника балансов ClientBalanceEntity");
            Console.WriteLine("         3 - Запрос справочника типов выпусов ObjectTypeEntity");
            Console.WriteLine("         4 - Запрос справочника групп выпусков ObjectGroupEntity");
            Console.WriteLine("         5 - Запрос справочника рынков MarketBoardEntity");
            Console.WriteLine("         6 - Запрос справочника счетов клиента ClientAccountEntity");
            Console.WriteLine("         7 - Запрос справочника портфелей субсчетов клиента SubAccountRazdelEntity");
            Console.WriteLine("         либо введите название сущности");

            switch (minorCommand)
            {
            case "1":
            {
                _ = requestCommand("AssetInfoEntity");

                break;
            }

            case "2":
            {
                _ = requestCommand("ClientBalanceEntity");

                break;
            }

            case "3":
            {
                _ = requestCommand("ObjectTypeEntity");

                break;
            }

            case "4":
            {
                _ = requestCommand("ObjectGroupEntity");

                break;
            }

            case "5":
            {
                _ = requestCommand("MarketBoardEntity");

                break;
            }

            case "6":
            {
                _ = requestCommand("ClientAccountEntity");

                break;
            }

            case "7":
            {
                _ = requestCommand("SubAccountRazdelEntity");

                break;
            }

            default:
            {
                if (!string.IsNullOrWhiteSpace(minorCommand))
                {
                    _ = requestCommand(minorCommand);
                }

                break;
            }
            }

            break;
        }

        case "3":
        {
            _ = connectionStateListenCommand();

            break;
        }

        case "4":
        {
            _ = getOrderLimitByInstrument();

            break;
        }

        case "5":
        {
            _ = setOrderEnterCommand();

            break;
        }

        case "6":
        {
            _ = setOrderCancelCommand();

            break;
        }
        }
    }
}

void resetConsole()
{
    Console.WriteLine("Выберите команду:");
    Console.WriteLine("1 - прослушивание entity сущностей");
    Console.WriteLine("2 - получить данные");
    Console.WriteLine("3 - получить состояние");
    Console.WriteLine("4 - получить лимит по инструменту");
    Console.WriteLine("5 - выставить заявку");
    Console.WriteLine("6 - снять заявку");
    Console.WriteLine("");
    Console.WriteLine("(Для завершения операции и возврата в это меню, нажмите клавишу 'End')");
}

async Task listenCommand(string entityName)
{
    baseCommand    = minorCommand = string.Empty;
    listenedEntity = entityName;
    Console.WriteLine($"Подключение к прослушиванию сущности {entityName}");

    dynamic req = new {
        Type        = entityName,
        Init        = true,
        Key         = 144950,
        Subscribe   = true,
        WaitForInit = false,
        CanCompress = false,
    };

    Console.WriteLine($"Выполняется запрос справочника {entityName}...");
    await routerClient.Request("#Data.Query", req);

    routerClient.Listen($"#Data.Bus.{entityName}",
                        data =>
                        {
                            switch (entityName)
                            {
                            case "AllTradeEntity":
                            case "OrderBookEntity":
                            {
                                var resArray = data["Updated"]?.Where(k => k["IdFI"]?.ToString() == "144950");
                                var arr      = JArray.FromObject(resArray ?? []);

                                if (arr.Count != 0)
                                {
                                    Console.WriteLine(arr.ToString());
                                }

                                break;
                            }

                            default:
                            {
                                Console.WriteLine(data.ToString());

                                break;
                            }
                            }
                        });
}

Task connectionStateListenCommand()
{
    baseCommand = minorCommand = string.Empty;

    Console.WriteLine("Подключение к прослушиванию ConnectionState.Bus");

    dynamic req = new {
        Init        = true,
        Subscribe   = true,
        WaitForInit = false,
        CanCompress = false,
    };

    routerClient.Listen("#ConnectionState.Bus",
                        data =>
                        {
                            Console.WriteLine(data.ToString());
                            routerClient.UnListen("#ConnectionState.Bus");
                            resetConsole();
                        });

    return Task.CompletedTask;
}

async Task requestCommand(string entityName)
{
    baseCommand    = minorCommand = string.Empty;
    listenedEntity = entityName;

    Console.WriteLine($"Подключение к прослушиванию сущности ${entityName}");

    dynamic req = new {
        Type = entityName,
        Init = true,
    };

    Console.WriteLine($"Выполняется запрос справочника ${entityName}...");
    var res = await routerClient.Request("#Data.Query", req);

    if (entityName == "AssetInfoEntity")
    {
        var paramsArray = (JArray)res["data"]["Data"];
        var resArray    = paramsArray.Where(k => k["Ticker"]?.ToString() == "SBER");
        Console.WriteLine(JArray.FromObject(resArray).ToString());
    }
    else
    {
        Console.WriteLine(res.ToString());
    }


    resetConsole();
}

async Task getOrderLimitByInstrument()
{
    baseCommand = minorCommand = string.Empty;

    Console.WriteLine("Введите параметры запроса:");
    Console.WriteLine("IdAccount: int, Идентификатор счёта (IdAccount из SubAccountRazdelEntity где RCode=MICEX)");

    var idAccount = Console.ReadLine();

    Console.WriteLine("IdRazdel: int, Идентификатор портфеля (IdRazdel из SubAccountRazdelEntity где RCode=MICEX)");
    var idRazdel = Console.ReadLine();


    Console.WriteLine("IdObject: int, Идентификатор выпуска (285270 для SBER)");
    var idObject = Console.ReadLine();


    Console.WriteLine("IdMarketBoard: int, Идентификатор рынка (92 для TQxx - МБ ЦК)");
    var idMarketBoard = Console.ReadLine();


    Console.WriteLine("BuySell: int, Направление сделки – покупка (1) или продажа (-1)");
    var buySell = Console.ReadLine();


    Console.WriteLine("BuySell: double, Цена");
    var price = Console.ReadLine();


    Console.WriteLine("IdOrderType: int, Вид заявки – рыночная (1) или лимитная (2)");
    var idOrderType = Console.ReadLine();


    Console.WriteLine(
        "LimitRequestType: int, Вид запрашиваемого лимита - (3) исходя из количества свободных денег, (4) исходя из стоимости портфеля");

    var limitRequestType = Console.ReadLine();


    dynamic req = new {
        IdDocumentType   = 1,
        IdAccount        = idAccount,
        IdRazdel         = idRazdel,
        IdObject         = idObject,
        IdMarketBoard    = idMarketBoard,
        BuySell          = buySell,
        Price            = price,
        IdOrderType      = idOrderType,
        LimitRequestType = limitRequestType,
    };

    var res = await routerClient.Request("#Order.Limit.Query", req);

    Console.WriteLine(res.ToString());

    resetConsole();
}

async Task setOrderEnterCommand()
{
    baseCommand = minorCommand = string.Empty;

    Console.WriteLine("Введите параметры запроса:");
    Console.WriteLine("IdAccount: int, Идентификатор счёта (IdAccount из SubAccountRazdelEntity где RCode=MICEX)");

    var idAccount = Console.ReadLine();

    Console.WriteLine("IdSubAccount: int, Идентификатор субсчёта (IdSubAccount из SubAccountRazdelEntity где RCode=MICEX)");

    var idSubAccount = Console.ReadLine();

    Console.WriteLine("IdRazdel: int, Идентификатор портфеля (IdRazdel из SubAccountRazdelEntity где RCode=MICEX)");
    var idRazdel = Console.ReadLine();


    Console.WriteLine("IdObject: int, Идентификатор выпуска (285270 для SBER)");
    var idObject = Console.ReadLine();

    Console.WriteLine("LimitPrice: double: Цена лимитной заявки");
    var limitPrice = Console.ReadLine();

    //Console.WriteLine("StopPrice: double: Цена лимитной заявки");
    var stopPrice = 0;// Console.ReadLine();


    Console.WriteLine("BuySell: int, Направление сделки – покупка (1) или продажа (-1)");
    var buySell = Console.ReadLine();

    Console.WriteLine("Quantity: int, Количество");
    var quantity = Console.ReadLine();

    Console.WriteLine("Comment: string, Комментарий");
    var comment = Console.ReadLine();

    Console.WriteLine("IdAllowedOrderParams: int, Идентификатор комбинации параметров (1069 - LMT, 15 - MKT)");
    var idAllowedOrderParams = Console.ReadLine();

    dynamic req = new {
        IdPriceControlType   = 3,
        IdAccount            = idAccount,
        IdSubAccount         = idSubAccount,
        IdRazdel             = idRazdel,
        IdObject             = idObject,
        LimitPrice           = limitPrice,
        StopPrice            = stopPrice,
        BuySell              = buySell,
        Quantity             = quantity,
        Comment              = comment,
        IdAllowedOrderParams = idAllowedOrderParams,
    };

    var res = await routerClient.Request("#Order.Enter.Query", req);

    Console.WriteLine(res.ToString());

    resetConsole();
}

async Task setOrderCancelCommand()
{
    baseCommand = minorCommand = string.Empty;

    Console.WriteLine("Введите параметры запроса:");
    Console.WriteLine("IdAccount: int, Идентификатор счёта (IdAccount из SubAccountRazdelEntity где RCode=MICEX)");

    var idAccount = Console.ReadLine();

    Console.WriteLine("IdSubAccount: int, Идентификатор субсчёта (IdSubAccount из SubAccountRazdelEntity где RCode=MICEX)");

    var idSubAccount = Console.ReadLine();

    Console.WriteLine("IdRazdel: int, Идентификатор портфеля (IdRazdel из SubAccountRazdelEntity где RCode=MICEX)");
    var idRazdel = Console.ReadLine();


    Console.WriteLine("NumEDocument: int, Клиентский номер заявки (NumEDocument из OrderEntity)");
    var numEDocument = Console.ReadLine();


    dynamic req = new {
        IdAccount        = idAccount,
        IdSubAccount     = idSubAccount,
        IdRazdel         = idRazdel,
        NumEDocumentBase = numEDocument,
    };

    var res = await routerClient.Request("#Order.Cancel.Query", req);

    Console.WriteLine(res.ToString());

    resetConsole();
}

void routerClientWhenBroadcasted(object? sender, RouterClient.BroadcastArgs e) { }
