using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

using Websocket.Client;

namespace ProTerminal.Api.Example;

internal sealed class WebSocketConnection : IDisposable
{
    public event EventHandler<JObject>? WhenReceived;

    public void Send(JObject obj)
    {
        _client.Send(obj.ToString(Formatting.None));
    }

    public WebSocketConnection()
    {
        Console.WriteLine("Создание веб-сокетного соединения");
        _client                       = new(new("ws://127.0.0.1:3366/router"));
        _client.ErrorReconnectTimeout = TimeSpan.FromSeconds(1);
        _client.MessageReceived.Subscribe(OnMessage);
        _client.Start();
        Console.WriteLine("Соединение создано успешно");
    }

    private void OnMessage(ResponseMessage response)
    {
        try
        {
            if (response.Text is null)
            {
                return;
            }

            WhenReceived?.Invoke(this, JObject.Parse(response.Text));
        }
        catch
        {
            //
        }
    }

    private readonly WebsocketClient _client;

    /// <inheritdoc />
    public void Dispose()
    {
        _client.Dispose();
    }
}
